---
id: fast-colors.colorlch
title: ColorLCH class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-colors](./fast-colors.md) &gt; [ColorLCH](./fast-colors.colorlch.md)

## ColorLCH class

[CIELCH color space](https://en.wikipedia.org/wiki/CIELAB_color_space)

This is a cylindrical representation of the CIELAB space useful for saturation operations This uses Hue values in "degree" format. So expect a range of \[0,360\]. Some other implementations instead uses radians or a normalized Hue with range \[0,1\]. Be aware of this when checking values or using other libraries. This implementation uses the D65 constants for 2 degrees. That determines the constants used for the pure white point of the XYZ space of 0.95047, 1.0, 1.08883. [https://en.wikipedia.org/wiki/Illuminant\_D65](https://en.wikipedia.org/wiki/Illuminant_D65) These constants determine how the XYZ, LCH and LAB colors convert to/from RGB.

<b>Signature:</b>

```typescript
export declare class ColorLCH 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(l, c, h)](./fast-colors.colorlch._constructor_.md) |  | Constructs a new instance of the <code>ColorLCH</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [c](./fast-colors.colorlch.c.md) |  | number |  |
|  [h](./fast-colors.colorlch.h.md) |  | number |  |
|  [l](./fast-colors.colorlch.l.md) |  | number |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [equalValue(rhs)](./fast-colors.colorlch.equalvalue.md) |  | Determines if one color is equal to another. |
|  [fromObject(data)](./fast-colors.colorlch.fromobject.md) | <code>static</code> | Construct a [ColorLCH](./fast-colors.colorlch.md) from a config object. |
|  [roundToPrecision(precision)](./fast-colors.colorlch.roundtoprecision.md) |  | Returns a new [ColorLCH](./fast-colors.colorlch.md) rounded to the provided precision |
|  [toObject()](./fast-colors.colorlch.toobject.md) |  | Converts the [ColorLCH](./fast-colors.colorlch.md) to a config object. |
