/*
 *  p4vasp is a GUI-program and library for processing outputs of the
 *  Vienna Ab-inition Simulation Package (VASP)
 *  (see http://cms.mpi.univie.ac.at/vasp/Welcome.html)
 *  
 *  Copyright (C) 2003  Orest Dubay <odubay@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef VisStructureArrowsDrawer_h
#define VisStructureArrowsDrawer_h
#include "VisDrawer.h"
#include "VisStructureDrawer.h"
#include "threads.h"
#include <FL/gl.h>
#include <GL/glu.h>

#ifndef VisWindow
class VisWindow;
#endif


class VisStructureArrowsDrawer : public VisDrawer{
  protected:
  VisStructureDrawer *structure_drawer;
  double *arrows;
  int arrows_len;
    
  public:
#ifdef SWIG
%mutable;
#endif  
  double arrow_radius,arrowhead_radius,arrowhead_length;
  double red,green,blue;
  double arrows_scale;
 
  VisStructureArrowsDrawer(VisStructureDrawer *sd);
  virtual const char *getClassName();
#ifndef SWIG    
  virtual void draw();  
#endif  
  virtual ~VisStructureArrowsDrawer();
  
  void updateStructure();

  int len();
  double *getArrow(int i);
  void setArrow(int i,double x, double y, double z);
  void setScale(double s);
  double getScale();
};

#endif
