% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw_text}
\alias{draw_text}
\title{Draw multiple text-strings in one go.}
\usage{
draw_text(text, x = 0.5, y = 0.5, size = 14, hjust = 0.5,
  vjust = 0.5, ...)
}
\arguments{
\item{text}{A vector of Character (not expressions) specifying the string(s) to be written.}

\item{x}{Vector of x coordinates.}

\item{y}{Vector of y coordinates.}

\item{size}{Font size of the text to be drawn.}

\item{hjust}{(default = 0.5)}

\item{vjust}{(default = 0.5)}

\item{...}{Style parameters, such as \code{colour}, \code{alpha}, \code{angle}, \code{size}, etc.}
}
\description{
This is a convenience function to plot multiple pieces of text at the same time. It cannot
handle mathematical expressions, though. For those, use \code{draw_label}.
}
\details{
Note that font sizes are scaled by a factor of 2.85, so sizes agree with those of
the theme. This is different from \code{geom_text} in ggplot2.

By default, the x and y coordinates specify the center of the text box. Set \code{hjust = 0, vjust = 0} to specify
the lower left corner, and other values of \code{hjust} and \code{vjust} for any other relative location you want to
specify.

For a full list of ... options, see  \code{\link{geom_label}}.
}
\examples{
# Draw onto a 1*1 drawing surface
ggdraw() + draw_text("Hello World!", x = 0.5, y = 0.5)
#
# Adorn a plot from the Anscombe data set of "identical" data.
library(ggplot2)

p <- ggplot(anscombe, aes(x1, y1)) + geom_point() + geom_smooth()
three_strings <- c("Hello World!", "to be or not to be", "over and out")
p + draw_text(three_strings, x = 8:10, y = 5:7, hjust = 0)
}
\seealso{
\code{\link{draw_label}}
}
