% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stash.R
\name{git_stash}
\alias{git_stash}
\alias{git_stash_save}
\alias{git_stash_pop}
\alias{git_stash_drop}
\alias{git_stash_list}
\title{Stashing changes}
\usage{
git_stash_save(
  message = "",
  keep_index = FALSE,
  include_untracked = FALSE,
  include_ignored = FALSE,
  repo = "."
)

git_stash_pop(index = 0, repo = ".")

git_stash_drop(index = 0, repo = ".")

git_stash_list(repo = ".")
}
\arguments{
\item{message}{optional message to store the stash}

\item{keep_index}{changes already added to the index are left intact in
the working directory}

\item{include_untracked}{untracked files are also stashed and then
cleaned up from the working directory}

\item{include_ignored}{ignored files are also stashed and then cleaned
up from the working directory}

\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}

\item{index}{The position within the stash list. 0 points to the
most recent stashed state.}
}
\description{
Temporary stash away changed from the working directory.
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_ignore}},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_signature}()},
\code{\link{git_tag}}
}
\concept{git}
