from .env import *
import os
import sys

VARIABLES = [
    PathVar("simple_cdd_dir", os.getcwd(),
            help="simple-cdd working directory"),
    # FIXME: should simple_cdd_dir just be merged with simple_cdd_temp?
    PathVar("simple_cdd_temp", ["{simple_cdd_dir}", "tmp"],
            help="directory where intermediate build data are stored"),
    PathVar("simple_cdd_logs", ["{simple_cdd_temp}", "log"],
            help="directory where execution logs are stored"),
    PathVar("simple_cdd_mirror", ["{simple_cdd_temp}", "mirror"],
            help="directory where the local mirror is stored"),
    PathVar("simple_cdd_basedir", ["{simple_cdd_temp}", "debian-cd"],
            help="working directory for debian-cd"),
    TextVar("server", "deb.debian.org",
            help="default server used for mirrors"),
    ListVar("mirror_components", ["main"],
            help="components to use to build the distributions"),
    ListVar("mirror_files", ["README", "doc/", "tools/"],
            help="extra files or directories to copy from the mirrors to the distribution CD"),
    TextVar("ARCH", Backtick("dpkg", "--print-architecture"),
            help="Architecture of the target distribution"),
    TextVar("CODENAME", Backtick("lsb_release", "--short", "--codename"), cmdline="--dist",
            help="distribution name (etch, lenny, wheezy, jessie, ..., sid)"),
    TextVar("DI_CODENAME", "{CODENAME}",
            help="distribution name for debian-installer"),
    TextVar("DISKTYPE", "CD",
            help="ISO image type ('CD' or 'DVD')"),
    TextVar("locale", cmdline="--locale",
            help="preselect this default locale for the distribution"),
    TextVar("keyboard", cmdline="--keyboard",
            help="preselect this keyboard in debian-installer (console-keymaps-at/keymap debconf question)"),
    BoolVar("proposed_updates", False, "--proposed-updates",
            help="specify if proposed updates should be used"),
    ListVar("kernel_packages", cmdline="--kernel-packages",
            help="list of kernel packages to include on the CD"),
    TextVar("profiles_udeb_dist", cmdline="--profiles-udeb-dist",
            help="pull simple-cdd-profiles udeb from specified distribution"),
    TextVar("extra_udeb_dist", cmdline="--extra-udeb-dist",
            help="pull in udebs from specified distribution"),
    TextVar("security_mirror", "http://security.debian.org/", cmdline="--security-mirror",
            help="security mirror URL"),
    TextVar("backports_mirror", "{debian_mirror}", cmdline="--backports-mirror",
            help="backports mirror URL"),
    ListVar("profiles", cmdline=("--profiles", "-p"),
            help="select profiles (examples in profiles/ dir)"),
    ListVar("local_packages", cmdline="--local-packages",
            help="list of files included on CD's local package repository"),
    ListVar("build_profiles", cmdline=("--build-profiles", "-b"),
            help="profiles only used while building the CD"),
    ListVar("mirror_tools", ["wget", "reprepro"], cmdline="--mirror-tools",
            help="list the mirror tools to be used"),
    ListVar("build_tools", "debian-cd", cmdline="--build-tools",
            help="list the build tools to be used"),
    ListVar("auto_profiles", cmdline=["--auto-profiles", "-a"],
            help="automatically install these profiles"),
    TextVar("updates_mirror", "{debian_mirror}", cmdline="--updates-mirror",
            help="specify mirror for $DIST-updates"),
    ListVar("simple_cdd_dirs",
            ["{simple_cdd_dir}", os.path.dirname(os.path.abspath(sys.argv[0])), "/usr/share/simple-cdd"],
            help="directories used to look for simple-cdd support scripts"),
    TextVar("debian_mirror", "http://{server}/debian/", "--debian-mirror",
            help="official Debian mirror to use to get Debian packages"),
    TextVar("rsync_debian_mirror", "{server}::debian",
            help="official Debian mirror to use to get Debian packages in rsync syntax, used only when using the rsync tool"),
    ListVar("mirror_components_extra", "{mirror_components}",
            help="distribution components to use when getting packages from debian_mirror_extra"),
    ListVar("ARCHES", "{ARCH}",
            help="all the architectures that will be present in the built ISO"),
    TextVar("wget_debian_mirror", "{debian_mirror}",
            help="Debian mirror base URL that will be used when invoking wget"),
    TextVar("simple_cdd_preseed", "preseed/file=/cdrom/simple-cdd/default.preseed",
            help="kernel command line parameter to enable simple-cdd debconf preseeding"),
    PathVar("TASK", ["{simple_cdd_temp}", "simple-cdd.task"],
            # FIXME: documentation to be improved
            help="debian-cd task to use"),
    ListVar("keyring", ["/usr/share/keyrings/debian-archive-keyring.gpg"], cmdline="--keyring",
            help="use specified keyrings (comma-separated) for verifying packages"),
    BoolVar("user_gnupghome", False,
            help="when true, use the user's gnupg keyring instead of a simple-cdd temporary keyring"),
    TextVar("checksum_file_type", "SHA256SUMS",
            help="name of checksum files to use to verify downloaded files"),
    BoolVar("do_mirror", True,
            help="when true, build a local mirror"),
    TextVar("di_release", "current",
            help="debian-installer version to use"),
    PathVar("BASEDIR", "{simple_cdd_basedir}",
            help="working directory for debian-cd"),
    PathVar("MIRROR", "{simple_cdd_mirror}",
            help="directory where the local mirror is stored"),
    TextVar("DEBVERSION", Backtick("lsb_release", "--short", "--release"),
            help="Numeric version of Debian release."),
    TextVar("OFFICIAL", "Unofficial",
            help="TODO: passed as is to debian-cd"),
    TextVar("OFFICIAL_VAL", "0",
            help="TODO: passed as is to debian-cd"),
    TextVar("ISOLINUX", "1",
            help="TODO: passed as is to debian-cd"),
    TextVar("NORECOMMENDS", "1",
            help="When set to 1, do not include recommends in the iso image"),
    TextVar("MAXCDS", "1",
            help="TODO: passed as is to debian-cd"),
    TextVar("OMIT_RELEASE_NOTES", "1",
            help="TODO: passed as is to debian-cd"),
    TextVar("DOJIGDO", "0",
            help="TODO: passed as is to debian-cd"),
    TextVar("MAXJIGDOS", "0",
            help="TODO: passed as is to debian-cd"),
    TextVar("INSTALLER_CD", "2",
            help="0: nothing special, "
                 "1: just add debian-installer (use TASK=tasks/debian-installer), "
                 "2: add d-i and base (use TASK=tasks/debian-installer+kernel)"),
    TextVar("MAXISOS", "ALL",
            help="TODO: passed as is to debian-cd"),
    PathVar("OUT", ["{simple_cdd_dir}", "images"],
            help="Directory where the generated ISO images will be stored"),
    ListVar("includes", ["debian-installer+kernel", "debian-installer"],
            # FIXME: I have no idea what this is (enrico)
            help="List of debian-cd include files to add to the current task"),
    TextVar("serial_console_speed", "115200",
            help="serial console speed used when booting with a serial console"),
    TextVar("serial_console_opts", "ttyS0,{serial_console_speed}",
            help="argument passed to the kernel to boot with a serial console"),
    TextVar("debian_cd_dir", "/usr/share/debian-cd",
            help="directory where debian-cd has its tools"),
    BoolVar("require_optional_packages", cmdline="--require-optional-packages",
            help="fail if missing optional packages (*.downloads)"),
    BoolVar("force_preseed", cmdline="--force-preseed",
            help="only issue a warning if a preseeding file is invalid"),
    BoolVar("use_serial_console", cmdline=["--serial-console", "-s"],
            help="enable serial console when booting the ISO image"),
    BoolVar("backports",
            help="use Debian backports"),
    ListVar("backports_packages",
            help="list of packages to get from backports instead of the normal distribution"),
    BoolVar("clean_mirror",
            help="Remove unused packages from the local mirror"),
    BoolVar("vga_normal"),
    ListVar("default_profiles", help="profiles which default to being selected in profile selection menu at install time"),
    ListVar("all_extras", help="files included on the media in the /simple-cdd dir"),
    ListVar("all_packages"),
    ListVar("BASE_INCLUDE"),
    ListVar("upstream_package_lists"),
    ListVar("checksum_files", help="files used to verify checksums on parts of the mirror other than packages, such as the installer media"),
    ListVar("package_files", help="profile specific lists of packages to install"),
    ListVar("preseed_files", help="profile specific preseeding files"),
    ListVar("exclude_files", help="profile specific list of packages to exclude from media"),
    ListVar("KERNEL_PARAMS"),
    ListVar("EXCLUDE"),
    ListVar("verify_release_keys",
            help="key IDs used to verify release files"),
    TextVar("udebs_filter_formula"),
    TextVar("debian_mirror_extra",
            help="if set, also get packages from this mirror"),
    ListVar("reprepro_opts", "-V",
            help="options added to all reprepro invocations"),
    TextVar("debian_cd_emulate_codename", help="if using non-official CODENAME, create links to emulate an existing codename"),
    TextVar("reprepro_retries", help="number of times reprepro attempts to download new dependencies"),
    TextVar("BOOT_TIMEOUT"),
    TextVar("commandline_opts"),
    TextVar("check_not_requested"),
    TextVar("debian_mirror_extra_dist"),
    TextVar("debian_mirror_extra_list_shell_hook"),
    ListVar("extra_udeb_dist_packages"),
    TextVar("mirror_udebcomponents_extra"),
    TextVar("choices"),
    TextVar("default_choices"),
    TextVar("backports_filter_formula"),
    TextVar("SUITE", "stable",
            help="suite used in the target distribution release file (i.e. stable/testing/unstable)"),
    TextVar("GNUPGHOME",
            help="location of the gnupg keyring to use to verify distrbutions"
                 " (overridden to point to a local copy if user_gnupghome is unset)"),
]
