#!/bin/bash

# this script intents to generate c++ code needed to init
# structures dealing with Material Design icons
# the first parameter is the _variable.scss file
# found in the scss sub directory after extracting files
# from a Material Design icons downladable zip archive
# the second is the cpp file which must be copied as
# library/tulip-ogl/src/TulipInitMaterialDesignIcons.cpp
# The files materialdesignicons-webfont.ttf materialdesignicons-webfont.woff
# and materialdesignicons-webfont.woff2 from the fonts sub directory
# must be copied in library/tulip-ogl/bitmaps

MDI_VARIABLES_FILE=$1
CPP_FILE=$2

MDI_VERSION=$(grep mdi-version ${MDI_VARIABLES_FILE} | awk -F '"' '{print $2}')
(echo "// Warning: do not update this file !!!";
 echo "// It was automatically generated by utils/scripts/generate_md_cpp_init_code.sh";
 echo "// from Material Design icons version ${MDI_VERSION}";
 echo;
 echo "std::string TulipMaterialDesignIcons::getVersion() {"
 echo "  return \"${MDI_VERSION}\";";
 echo "}";
 echo;
 echo "static void initIconCodePoints() {";
 grep '":' ${MDI_VARIABLES_FILE} | awk -F ',' '{print $1}' | awk -F '"' '{print $2 $3}' | awk '{print $1 $2}' | awk -F ':' '{printf "  addIconCodePoint(\"md-%s\", 0x%s);\n", $1, $2}';
 echo;
 echo "  iconsNames.reserve(iconCodePoint.size());";
 echo;
 echo "  for (const auto &it : iconCodePoint) {";
 echo "    iconsNames.emplace_back(it.first);";
 echo "  }";
 echo "}") > ${CPP_FILE}

